#ifndef RFDECODE_H
#define RFDECODE_H

enum Remote_Control_Status{	
	R_INIT = 			0, 
	R_OFF = 			1,
	R_1_SPEED = 		2, 
	R_2_SPEED = 		3,
	R_3_SPEED = 		4,
	R_4_SPEED = 		5,
	R_5_SPEED =         6,
	R_SMART = 			7,
	R_1H = 				8,
	R_2H = 				9,
	R_4H = 				10,
	R_6H = 				11,
	R_8H = 				12,
};
extern xdata 	uint8 	RF_Channel;
// <<< Use Configuration Wizard in Context Menu >>>
// <e> RF Enable/Disable
#define RF_Control 0
#if (RF_Control == 1)

void IRLearning_mode(void);
extern void IRDecode_Init (void);


extern uint8 			IR_Byte[5];
extern xdata	uint8 	RF_Learning_Address[3];
extern uint8	test_ir;

	// <h> Set IR_DEC_CTRL
		// <o.6> IRIN_SEL <0=> IR decode data input from PIN CH3 <1=> IR decode data input from PIN CH7 
			#define IR_DEC_CTRL_REGS 0xC0
	// </h>

	// <h> Set IR_DEC_SET
		// <o.0..2> CLK_DIV_SEL <0=> 24MHz <1=> 16MHz <2=> 8MHz <3=> 6MHz <4=> 3MHz <5=> 2MHz 
		// <o.3..4> DIN_DB_SEL <0=> 0ns <1=> 250ns <2=> 500ns <3=> 1000ns
		// <o.5> DIN_TYP <0=> Data Type1 <1=> Data Type2
		// <i> Data Type1 = Falling to Rising edge: Duty > 50% -> Din = 0; Duty < 50% -> Din = 1
		// <i> Data Type2 = Falling to Rising edge: Duty > 50% -> Din = 1; Duty < 50% -> Din = 0
		// <o.6> DOUT_REV <0=> First input data is LSB <1=> First input data is MSB 
		// <o.7> HEADER_EN <0=> No HEADER <1=> With HEADER
			#define IR_DEC_SET_REGS 		0x95
	// </h>
	
	//<h> Remote control code set
		//<h> Head code set
		
			// <o> 	Head code 1 TIME set (unit : us)
					#define IR_HEADER1_TIME 		5000
					
			// <o> 	Head code 2 TIME set (unit : us)
					#define IR_HEADER2_TIME 		7800
		//</h>
		
		//<e> RF decoding to UR Enable
			#define RF_decoding_UR_Enable 	0
		// </e>
		
		// <e> No Remote control Learn mode
			#define No_Remote_control_Learn_mode 0
			#if (No_Remote_control_Learn_mode == 1)
				//<h> RF address code set
					//<o> Set RF address1<0x00-0xFF>
						#define RF_ADDRESS_1			0x7F
						
					//<o> Set RF address2<0x00-0xFF>
						#define RF_ADDRESS_2			0xD4
					
					//<o> Set RF address3<0x00-0xFF>
						#define RF_ADDRESS_3			0x0F
				//</h>
			#endif
		// </e> 
		
		#if (No_Remote_control_Learn_mode == 0)
			//<o> Set learn time(unit : sec)<0-20>
				#define Learning_TIME					(10)
			//<o> Judge the times of successful learning(unit : 10 times)<0-20>
				#define Successful_Learning_TIMES		(1)*10
		#endif
		
		// <h> 	RF data code set
			// <h>  Button speed 1
				// <o> 	Data code 1<0x00-0xFF>
					#define RF_DATA_1_1				0x10
					
				// <o> Data code 2<0x00-0xFF>
					#define RF_DATA_1_2				0x3E
			// </h>

			// <h>  Button speed 2
				// <o> 	Data code 1<0x00-0xFF>
					#define RF_DATA_2_1				0x90
					
				// <o> Data code 2<0x00-0xFF>
					#define RF_DATA_2_2				0x36
			// </h>

			// <h>  Button speed 3
				// <o> 	Data code 1<0x00-0xFF>
					#define RF_DATA_3_1				0xA0
					
				// <o> Data code 2<0x00-0xFF>
					#define RF_DATA_3_2				0x35
			// </h>

			// <h>  Button speed 4
				// <o> 	Data code 1<0x00-0xFF>	
					#define RF_DATA_4_1				0x30
					
				// <o> Data code 2<0x00-0xFF>
					#define RF_DATA_4_2				0x3C
			// </h>

			// <h>  Button off
				// <o> 	Data code 1<0x00-0xFF>	
					#define RF_DATA_off_1			0xB0
					
				// <o> Data code 2<0x00-0xFF>
					#define RF_DATA_off_2			0x34
			// </h>
			
			// <h>  Button SMART
				// <o> 	Data code 1<0x00-0xFF>	
					#define RF_DATA_smart_1			0xC0
					
				// <o> Data code 2<0x00-0xFF>
					#define RF_DATA_smart_2			0x33
			// </h>
			
			// <h>  Button Timer 3H
				// <o> 	Data code 1<0x00-0xFF>	
					#define RF_DATA_3H_1			0x40
					
				// <o> Data code 2<0x00-0xFF>
					#define RF_DATA_3H_2			0x3B
			// </h>
			
			// <h>  Button Timer 6H
				// <o> 	Data code 1<0x00-0xFF>	
					#define RF_DATA_6H_1			0x80
					
				// <o> Data code 2<0x00-0xFF>
					#define RF_DATA_6H_2			0x37
			// </h>
			
			// <h>  Button Timer 9H
				// <o> 	Data code 1<0x00-0xFF>	
					#define RF_DATA_9H_1			0x20
					
				// <o> Data code 2<0x00-0xFF>
					#define RF_DATA_9H_2			0x3D
			// </h>
		// </h>
		
		#if (Remote_control_decoding_Enable == 1) && (Observe_Speed_UI == 1)
			#error Wrong setting Remote_control_decoding_Enable and Observe_Speed_UI !!!!
		#endif
		
	// </h>
#endif
// </e>
// <<< end of configuration section >>>
#endif